/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.MountingFramePanelBean;
import com.ibm.hwmca.base.ntfy.NotificationAbstractTasklet;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.NotifyClassProperties;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.Map;

public class SwitchingTasklet
extends NotificationAbstractTasklet {
    private static final String TRACE_MASKT = "XNTYSWTT";
    private static final String TRACE_MASKF = "XNTYSWTF";
    private static final String TRACE_MASKD = "XNTYSWTD";
    private static final String SWITCHING_MOUNT_POINT = "TabbedPane1";
    private static final String UI_INFO_KEY = "uiinfo";
    private static final String MAIN_TASKLET_KEY = "maintasklet";

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> SwitchingTasklet.service()");
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (request.isCanceled() || request.isDisposed() || command.equals("") || command.equals("CANCEL")) {
            this.serviceDisposed(request, response);
        } else {
            this.errorId = (short)-32735;
            this.serviceSwitch(request, response);
        }
    }

    private final void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceInitial()");
        MountingFramePanelBean bean = new MountingFramePanelBean();
        bean.setBeanName("MountingPanel");
        DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
        DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.PairingListTasklet", null);
        delegate.setMountPoint(SWITCHING_MOUNT_POINT);
        response.replace(frame, new DisplayAreaDescriptor[]{delegate});
    }

    private final void serviceSwitch(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceSwitch()");
        if (request.getData("CommandName").equals("SourcesItem")) {
            Trace.trace(TRACE_MASKT, "switching to sources");
            Map sourceMap = NotificationService.getManager().getSourceClassPropertyMap();
            Trace.trace(TRACE_MASKF, "number of sources: " + sourceMap.size());
            MountingFramePanelBean bean = new MountingFramePanelBean();
            bean.setBeanName("MountingPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
            DisplayAreaDescriptor[] delegates = new DisplayAreaDescriptor[sourceMap.size()];
            int i = 0;
            Iterator iterator = sourceMap.keySet().iterator();
            while (iterator.hasNext()) {
                String sourceName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "source name: " + sourceName);
                NotifyClassProperties sourceProps = (NotifyClassProperties)sourceMap.get(sourceName);
                Map sourceUI = (Map)sourceProps.get(UI_INFO_KEY);
                String taskletName = (String)sourceUI.get(MAIN_TASKLET_KEY);
                Trace.trace(TRACE_MASKF, "tasklet name:" + taskletName);
                delegates[i] = new DisplayAreaDescriptorDelegate(taskletName, null);
                delegates[i].setMountPoint(SWITCHING_MOUNT_POINT);
                ++i;
            }
            response.replace(frame, delegates);
        } else if (request.getData("CommandName").equals("SinksItem")) {
            Trace.trace(TRACE_MASKT, "switching to sinks");
            Map sinkMap = NotificationService.getManager().getSinkClassPropertyMap();
            Trace.trace(TRACE_MASKF, "number of sinks: " + sinkMap.size());
            MountingFramePanelBean bean = new MountingFramePanelBean();
            bean.setBeanName("MountingPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
            DisplayAreaDescriptor[] delegates = new DisplayAreaDescriptor[sinkMap.size()];
            int i = 0;
            Iterator iterator = sinkMap.keySet().iterator();
            while (iterator.hasNext()) {
                String sinkName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "sink name: " + sinkName);
                NotifyClassProperties sinkProps = (NotifyClassProperties)sinkMap.get(sinkName);
                Map sinkUI = (Map)sinkProps.get(UI_INFO_KEY);
                String taskletName = (String)sinkUI.get(MAIN_TASKLET_KEY);
                Trace.trace(TRACE_MASKF, "tasklet name:" + taskletName);
                delegates[i] = new DisplayAreaDescriptorDelegate(taskletName, null);
                delegates[i].setMountPoint(SWITCHING_MOUNT_POINT);
                ++i;
            }
            response.replace(frame, delegates);
        } else if (request.getData("CommandName").equals("NotificationsItem")) {
            Trace.trace(TRACE_MASKD, "switching to notifications");
            MountingFramePanelBean bean = new MountingFramePanelBean();
            bean.setBeanName("MountingPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
            DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.PairingListTasklet", null);
            delegate.setMountPoint(SWITCHING_MOUNT_POINT);
            response.replace(frame, new DisplayAreaDescriptor[]{delegate});
        } else if (request.getData("CommandName").equals("UsersItem")) {
            Trace.trace(TRACE_MASKD, "switching to users");
            MountingFramePanelBean bean = new MountingFramePanelBean();
            bean.setBeanName("MountingPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
            DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.UserManagerTasklet", null);
            delegate.setMountPoint(SWITCHING_MOUNT_POINT);
            response.replace(frame, new DisplayAreaDescriptor[]{delegate});
        } else if (request.getData("CommandName").equals("TimesItem")) {
            Trace.trace(TRACE_MASKT, "switching to times");
            MountingFramePanelBean bean = new MountingFramePanelBean();
            bean.setBeanName("MountingPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MountingPanel", bean, null, null);
            DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.TimeManagerTasklet", null);
            delegate.setMountPoint(SWITCHING_MOUNT_POINT);
            response.replace(frame, new DisplayAreaDescriptor[]{delegate});
        } else {
            this.unknownCommand(response, (String)request.getData("CommandName"));
        }
    }
}

